function [t Cfo] = post_f_1()
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% post processor - plot Cf
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% clc
% clear all 
close all;	% close all the open figure windows

%%%%%%%%%%% read finp.txt %%%%%%%%%%%%
fid = fopen('finp.txt','r');

line = fgets(fid);	% read line (Ne, Nn, Nb, Nm, Np)
v = sscanf(line, '%i');
Ne = v(1);
Nn = v(2);
Nb = v(3);
Nm = v(4);
Np = v(5);

line = fgets(fid);	% read line (Nd, Ng, Ns)
v = sscanf(line, '%i');
Ns = v(3);

line = fgets(fid);	% read line (Sx, Kappa, tc)
line = fgets(fid);	% read line (tmax, dt, dto)
line = fgets(fid);	% read line (theta)
line = fgets(fid);	% read line (ipar(2:3), ipar(6))
line = fgets(fid);	% read line (fpar(1:2), fpar(11))

%%%%%%%%%%% read fcount.txt %%%%%%%%%%%%
fid = fopen('fcount.txt','r');
line = fgets(fid);	% read line (Nc, Nf)
v = sscanf(line, '%i');
Nf = v(2);

%%%%%%%%%% read V.txt %%%%%%%%%%%
fid = fopen('V.txt','r');

for m = 1:Nm
  line = fgets(fid);	% read line (e, Vx)
  v = sscanf(line, '%e');
  Vx = v(2);
end	% m

%%%%%%%%%% read materials.txt %%%%%%%%%%%
if Np>0
  fid = fopen('materials.txt','r');

  for m = 1:Nm
    line = fgets(fid);	% read line (Ao)
    for p = 1:Np
      line = fgets(fid);	% read line (par)
    end	% p
  end	% m
end

%%%%%%%%%% read nodes.txt %%%%%%%%%%%
fid = fopen('nodes.txt','r');

x = zeros(Nn,1);
for n=1:Nn
  line = fgets(fid);	% read line (x, c(x,0 1:Ns))
  v = sscanf(line, '%e %e %s');
  x(n) = v(1);	%  (x)
end;	% n

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
qc = zeros(Nn, Ns, Nf);
qd = zeros(Nn, Ns, Nf);
Cf = zeros(Nn, Ns, Nf);

%%%%%%%%%%% read fqc.txt %%%%%%%%%%%%
fid = fopen('fqc.txt','r');
for k = 1:Nf;
  d = fscanf(fid, '%s %s',2);	% dummy
  d = fscanf(fid, '%i',1);	% dummy (n)
  d = fscanf(fid, '%s %s',2);	% dummy
  t(k) = fscanf(fid, '%e',1);	% time
  d = fscanf(fid, '%s',1);	% dummy (header)
  for n = 1:Nn;
    qc(n,:,k) = fscanf(fid, '%e' ,Ns);	% qc
  end	% n
end	% k

%%%%%%%%%%% read fqd.txt %%%%%%%%%%%%
fid = fopen('fqd.txt','r');
for k = 1:Nf;
  d = fscanf(fid, '%s %s',2);	% dummy
  d = fscanf(fid, '%i',1);	% dummy (n)
  d = fscanf(fid, '%s %s',2);	% dummy
  t(k) = fscanf(fid, '%e',1);	% time
  d = fscanf(fid, '%s',1);	% dummy (header)
  for n = 1:Nn;
    qd(n,:,k) = fscanf(fid, '%e' ,Ns);	% qd
  end	% n
end	% k

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Cf = (qc + qd) / Vx;	% (qc + qd)/v
for k = 1:Nf;
  for s = 1:Ns;
    Cfo(s,k) = Cf(Nn,s,k);		% store Cf at x=1
  end	% s
end	% k

%%%%%%%%%%% write BTC_f.txt %%%%%%%%%%%%

fid = fopen('BTC_f.txt','w');
fprintf(fid, '% 5s % 14s % 14s \n', 'k', 't(k)', 'Cfo(k)');
for k = 1:Nf;
  fprintf(fid, '% 5i % 14.7e % 14.7e % 14.7e % 14.7e \n', k, t(k), Cfo(1,k));
end	% k

% fclose('all');  % close all files

